	PROGRAM applagsl
	USE MSIMSL
c**********************************************************************
c
c   FORTRAN program to apply nonlinear vector time series lag selection
c   techniques to given dataset.
c   Also apply tests of nonlinearity to that dataset.
c
c   The parameters are defined in the following manner:
c   nkmx = the maximum number of times series in the multivariate
c   nmx = the maximum number of observations for the time series.
c   npmx = the maximum allowable autoregressive order.  npmx = 5.
c   nqmx = the maximum length of the full-stacking vector.
c   
c   Written: 04/30/04 JLH
c   Subprograms called: genvarn, genbvar, mvlrt, mvkeenan,vech,
c                       oritest
c**********************************************************************
c
	parameter (nkmx = 5, nmx = 500, npmx = 10, maxwk = 71950, in = 30)
	implicit double precision (a-h, p-z)
c
      double precision x(nmx,nkmx),univar(nmx)
	double precision kendptaus(nkmx,nkmx,npmx)
	double precision kendtaus(nkmx,nkmx,npmx)
	double precision tauprobs(nkmx,nkmx,npmx)
	double precision ptauprobs(nkmx,nkmx,npmx)
	double precision r(npmx,nkmx,nkmx),rt(npmx,nkmx,nkmx)
	double precision pt(npmx,nkmx,nkmx)
	double precision wk(maxwk,nkmx+3),z(npmx,nkmx)
      character infile*50,outfile*50,outfile2*50,outfile3*50
c
c   Create interface for using program:
c
      write(*,*) " k,nob?"
      read(*,*) k,nob
      write(*,*) "Name of input file?"
      read(*,*) infile
      open(10,file=infile)
      do i = 1,nob
      read(10,*) (x(i,j), j = 1,k)
c           if (x(i,1) .lt. .01) x(i,1)=.01
      enddo
      close(10)
c
c	do i = 1,nob
c	   write(*,*) (x(i,j), j = 1,k)
c	enddo
      write(*,*) " Name of output file for test results?"
      read(*,*) outfile
      write(*,*) " Name of output file for coefficients?"
      read(*,*) outfile2
	write(*,*) " Name of output file for acf and pacf?"
	read(*,*) outfile3
      write(*,*) "  AR order for test?"
      read(*,*) np
c
c   End of user interface.  Now begin writing results to the output
c   file (outfile) specified by the user:
c
c   Opening statements:
c
      open(500,file=outfile)
      open(10,file=outfile2)
      write(500,*) "Results for Multivariate Tests of Nonlinearity"
      write(500,*)
      write(500,90) k,nob
 90   format("Number of series and number of observations:",9X,2I7)
      write(500,100)  np
 100  format(" Number of lags used in test:",19X,I7)
      write(500,*)
c
c   Write "header" to output file:
c
      write(500,120)
 120  format(10X,"Number of",39X,"Degrees of Freedom",8X,"W-L",8X,
     +	"H-Tr",8X,"P-Tr")
      write(500,130)
 130  format(X,"Test",4X,"Observations",8X,"W-L",8x,"H-Tr",6x,"P-Tr",
     +	7X,"Num.",6X,"Den.",8X,"P-value",4X,"P-value",4X,"P-value")
      write(500,140)
 140  format(" ---------------------------------------------------------
     +------------------------------------")
      write(500,*)
c
c   Conduct multivariate tests of nonlinearity. 
	call mvtsay(x,nob,k,np,u1,u2,u3,ndf1,ndf2,pvale,pvalc,pvalf)
	write(500,164) nob,u1,u2,u3,ndf1, ndf2, pvale, pvalc, pvalf
	call mvkeenan(x,nob,k,np,u1,u2,u3,ndf1,ndf2,pvale,pvalc,pvalf)
	write(500,163) nob,u1,u2,u3,ndf1,ndf2,pvale,pvalc,pvalf
	call mvlrt(x,nob,k,np,u1,u2,u3,ndf1,ndf2,pvale,pvalc,pvalf,1)
	write(500,162) nob,u1,u2,u3,ndf1,ndf2,pvale,pvalc,pvalf
 162	format(X,"LRT",6X,I6,11X,3F10.6,4X,I6,5X,I6,6X,F7.6,4X,F7.6,4X,
     +	F7.6)
 163	format(X,"MVKeen",3X,I6,11X,3F10.6,4X,I6,5X,I6,6X,F7.6,4X,F7.6,
     +	4X,F7.6)
 164	format(X,"MVTsay",3X,I6,11X,3F10.6,4X,I6,5X,I6,6X,F7.6,4X,F7.6,
     +	4X,F7.6)
c
c   Conduct Tsay's (1986) original univariate test of nonlinearity for
c   each series:
c
	do j = 1,k
	   do jj = 1,nob
	      univar(jj) = x(jj,j)
	   enddo
	   call origf(univar,nob,np,f,ndf1,ndf2,puniv)
	   write(500,170) nob,j,f,ndf1,ndf2,puniv
 170	   format(X,"Univ.",4X,I6,2X,I5,2X,F12.6,4X,I6,5X,I6,6X,F7.6)
	enddo
c
c   Conduct Semimult version of Tsay's (1986) original univariate test of nonlinearity for
c   each series:
c
	do j = 1,k
	   call semimultf(x,k,j,nob,np,f,ndf1,ndf2,puniv)
	   write(500,171) nob,j,f,ndf1,ndf2,puniv
 171	   format(X,"SM.  ",4X,I6,2X,I5,2X,F12.6,4X,I6,5X,I6,6X,F7.6)
	enddo

	call kptaus(x,nob,k,10,0.0d0,wk,z,kendtaus,tauprobs,kendptaus,
     +        ptauprobs)
	call compr(nob,10,k,x,in,r,rt)
	call mvpacf(nob,10,k,x,pt)
	do i = 1,k
	do j = 1,k
	   pt(1,i,j) = rt(1,i,j)
	enddo
	enddo
c
	open(600,file=outfile3)
	write(600,230) k
	do ilag = 1,10
	   do itsr = 1,k
	      write(600,240) ilag, nob, 
     +		   (rt(ilag,itsr,itsp),itsp=1,k),
     +		   (pt(ilag,itsr,itsp),itsp=1,k),
     +		   (r(ilag,itsr,itsp),itsp=1,k),
     +		   (kendtaus(itsr,itsp,ilag),itsp=1,k),
     +		   (tauprobs(itsr,itsp,ilag),itsp=1,k),
     +		   (kendptaus(itsr,itsp,ilag),itsp=1,k),
     +		   (ptauprobs(itsr,itsp,ilag),itsp=1,k)
	   enddo
	enddo
	close(600)
c
 230	format("lag    n     Statistics in groups of ",I1,".")
 240	format(I2,4X,I4,2X,20F8.4)
c
	stop
	end    
